define(['jQuery', 'angular', 'app'], function ($, angular, app) {
	"use strict";
	app.service('eulaService', function ($templateCache) {
		return {
			setAcceptedDate: function (dateAccepted) {
				localStorage.setItem(window.location.pathname + 'eula', JSON.stringify(dateAccepted));
				this.acceptedThisSession = true;
			},
			isAccepted: function () {
				if (this.acceptedThisSession) {
					return true;
				}

				var dateAccepted = localStorage.getItem(window.location.pathname + 'eula');
				if (dateAccepted) {
					dateAccepted = JSON.parse(dateAccepted).dateAccepted;

					$.ajax({ url: 'src/core/eula/eula_content.html',
						async: false,
						dataType: 'text',
						cache: false,
						success: function(data) {
							var eulaHtml = $(data),
								dateModifiedString = eulaHtml.find('#modified-date').text(),
								dateModified = new Date(dateModifiedString).getTime();

							if ( dateModified > dateAccepted ) {
								dateAccepted = null;
							}
						}
					});

					var accepted = dateAccepted ? true : false;
					if (accepted && !this.acceptedThisSession) {
						this.acceptedThisSession = true;
					}

					return accepted;
				}

				return false;
			},
			acceptedThisSession: false
		};
	});
});